import ui
import systemSetting
import net
import chat
import app
import localeInfo
import constInfo
import player
import uiPrivateShopBuilder
if app.__ENABLE_NEW_OFFLINESHOP__:
	import offlineshop
blockMode = 0
viewChatMode = 0

class OptionDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__Initialize()
		self.__Load()
		self.RefreshViewChat()
		self.RefreshAlwaysShowName()
		self.RefreshShowDamage()
		self.RefreshShowSalesText()
		self.RefreshShowCompanions()
		if app.ENABLE_NEW_GAME_OPTIONS:
			self.RefreshGoldLogStatus()
			self.RefreshOfflineShops()
			self.RefreshFramesStatus()
		if app.ENABLE_PICKUP_FILTER:
			self.__RefreshPickupIgnoreButtons()


	def __del__(self):
		ui.ScriptWindow.__del__(self)
		print " -------------------------------------- DELETE GAME OPTION DIALOG"

	def __Initialize(self):
		self.titleBar = 0
		self.nameColorModeButtonList = []
		self.viewTargetBoardButtonList = []
		self.pvpModeButtonDict = {}
		self.blockButtonList = []
		self.viewChatButtonList = []
		self.alwaysShowNameButtonList = []
		self.showDamageButtonList = []
		self.showsalesTextButtonList = []
		self.showCompanionsButtonList = []
		if app.ENABLE_NEW_GAME_OPTIONS:
			self.chatFilterList = []
			self.showGoldLogButtonList = []
			self.OfflineShopsList = []
			self.showFramesList = []
		if app.ENABLE_PICKUP_FILTER:
			self.pickupIgnoreButtonList = []

	def Destroy(self):
		self.ClearDictionary()

		self.__Initialize()
		print " -------------------------------------- DESTROY GAME OPTION DIALOG"

	def __Load_LoadScript(self, fileName):
		try:
			pyScriptLoader = ui.PythonScriptLoader()
			pyScriptLoader.LoadScriptFile(self, fileName)
		except:
			import exception
			exception.Abort("OptionDialog.__Load_LoadScript")

	def __Load_BindObject(self):
		try:
			GetObject = self.GetChild
			self.titleBar = GetObject("titlebar")
			self.nameColorModeButtonList.append(GetObject("name_color_normal"))
			self.nameColorModeButtonList.append(GetObject("name_color_empire"))
			self.viewTargetBoardButtonList.append(GetObject("target_board_no_view"))
			self.viewTargetBoardButtonList.append(GetObject("target_board_view"))
			self.pvpModeButtonDict[player.PK_MODE_PEACE] = GetObject("pvp_peace")
			self.pvpModeButtonDict[player.PK_MODE_REVENGE] = GetObject("pvp_revenge")
			self.pvpModeButtonDict[player.PK_MODE_GUILD] = GetObject("pvp_guild")
			self.pvpModeButtonDict[player.PK_MODE_FREE] = GetObject("pvp_free")
			self.blockButtonList.append(GetObject("block_exchange_button"))
			self.blockButtonList.append(GetObject("block_party_button"))
			self.blockButtonList.append(GetObject("block_guild_button"))
			self.blockButtonList.append(GetObject("block_whisper_button"))
			self.blockButtonList.append(GetObject("block_friend_button"))
			self.blockButtonList.append(GetObject("block_party_request_button"))
			self.viewChatButtonList.append(GetObject("view_chat_on_button"))
			self.viewChatButtonList.append(GetObject("view_chat_off_button"))
			self.alwaysShowNameButtonList.append(GetObject("always_show_name_on_button"))
			self.alwaysShowNameButtonList.append(GetObject("always_show_name_off_button"))
			self.showDamageButtonList.append(GetObject("show_damage_on_button"))
			self.showDamageButtonList.append(GetObject("show_damage_off_button"))
			self.showsalesTextButtonList.append(GetObject("salestext_on_button"))
			self.showsalesTextButtonList.append(GetObject("salestext_off_button"))

			self.showCompanionsButtonList.append(GetObject("show_companions_pets_button"))
			self.showCompanionsButtonList.append(GetObject("show_companions_mounts_button"))

			if app.ENABLE_PICKUP_FILTER:
				for type in ["weapon", "armor", "head", "shield", "wrist", "foots", "neck", "ear", "etc"]:
					self.pickupIgnoreButtonList.append(self.GetChild("drops_ignore_" + type))

			if app.ENABLE_NEW_GAME_OPTIONS:
				self.chatFilterList.append(GetObject("chat_filter_dice"))
				self.showGoldLogButtonList.append(GetObject("chat_filter_gold"))
				self.showFramesList.append(GetObject("option_frames"))
				self.OfflineShopsList.append(GetObject("offline_shop_filter"))

		except:
			import exception
			exception.Abort("OptionDialog.__Load_BindObject")

	def __Load(self):
		self.__Load_LoadScript("uiscript/gameoptiondialog.py")
		self.__Load_BindObject()

		self.SetCenterPosition()

		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))

		self.nameColorModeButtonList[0].SAFE_SetEvent(self.__OnClickNameColorModeNormalButton)
		self.nameColorModeButtonList[1].SAFE_SetEvent(self.__OnClickNameColorModeEmpireButton)

		self.viewTargetBoardButtonList[0].SAFE_SetEvent(self.__OnClickTargetBoardViewButton)
		self.viewTargetBoardButtonList[1].SAFE_SetEvent(self.__OnClickTargetBoardNoViewButton)

		self.pvpModeButtonDict[player.PK_MODE_PEACE].SAFE_SetEvent(self.__OnClickPvPModePeaceButton)
		self.pvpModeButtonDict[player.PK_MODE_REVENGE].SAFE_SetEvent(self.__OnClickPvPModeRevengeButton)
		self.pvpModeButtonDict[player.PK_MODE_GUILD].SAFE_SetEvent(self.__OnClickPvPModeGuildButton)
		self.pvpModeButtonDict[player.PK_MODE_FREE].SAFE_SetEvent(self.__OnClickPvPModeFreeButton)

		self.blockButtonList[0].SetToggleUpEvent(self.__OnClickBlockExchangeButton)
		self.blockButtonList[1].SetToggleUpEvent(self.__OnClickBlockPartyButton)
		self.blockButtonList[2].SetToggleUpEvent(self.__OnClickBlockGuildButton)
		self.blockButtonList[3].SetToggleUpEvent(self.__OnClickBlockWhisperButton)
		self.blockButtonList[4].SetToggleUpEvent(self.__OnClickBlockFriendButton)
		self.blockButtonList[5].SetToggleUpEvent(self.__OnClickBlockPartyRequest)

		self.blockButtonList[0].SetToggleDownEvent(self.__OnClickBlockExchangeButton)
		self.blockButtonList[1].SetToggleDownEvent(self.__OnClickBlockPartyButton)
		self.blockButtonList[2].SetToggleDownEvent(self.__OnClickBlockGuildButton)
		self.blockButtonList[3].SetToggleDownEvent(self.__OnClickBlockWhisperButton)
		self.blockButtonList[4].SetToggleDownEvent(self.__OnClickBlockFriendButton)
		self.blockButtonList[5].SetToggleDownEvent(self.__OnClickBlockPartyRequest)

		self.viewChatButtonList[0].SAFE_SetEvent(self.__OnClickViewChatOnButton)
		self.viewChatButtonList[1].SAFE_SetEvent(self.__OnClickViewChatOffButton)

		self.alwaysShowNameButtonList[0].SAFE_SetEvent(self.__OnClickAlwaysShowNameOnButton)
		self.alwaysShowNameButtonList[1].SAFE_SetEvent(self.__OnClickAlwaysShowNameOffButton)

		self.showDamageButtonList[0].SAFE_SetEvent(self.__OnClickShowDamageOnButton)
		self.showDamageButtonList[1].SAFE_SetEvent(self.__OnClickShowDamageOffButton)

		self.showsalesTextButtonList[0].SAFE_SetEvent(self.__OnClickSalesTextOnButton)
		self.showsalesTextButtonList[1].SAFE_SetEvent(self.__OnClickSalesTextOffButton)

		self.showCompanionsButtonList[0].SetToggleUpEvent(self.__OnClickHidePetsButton)
		self.showCompanionsButtonList[0].SetToggleDownEvent(self.__OnClickHidePetsButton)

		self.showCompanionsButtonList[1].SetToggleUpEvent(self.__OnClickHideMountsButton)
		self.showCompanionsButtonList[1].SetToggleDownEvent(self.__OnClickHideMountsButton)

		if app.ENABLE_PICKUP_FILTER:
			for i in xrange(len(self.pickupIgnoreButtonList)):
				self.pickupIgnoreButtonList[i].SetToggleUpEvent(lambda type = i, ignore = 0 : self.__OnClickPickupIgnoreButton(type, ignore))
				self.pickupIgnoreButtonList[i].SetToggleDownEvent(lambda type = i, ignore = 1 : self.__OnClickPickupIgnoreButton(type, ignore))

		if app.ENABLE_NEW_GAME_OPTIONS:
			self.chatFilterList[0].SetToggleUpEvent(self.__ChatFilterDiceEnable) #1
			self.chatFilterList[0].SetToggleDownEvent(self.__ChatFilterDiceDisable) #0
			self.__ChatFilterRefresh()

			self.showGoldLogButtonList[0].SetToggleUpEvent(self.__OnClickShowGoldOffButton)
			self.showGoldLogButtonList[0].SetToggleDownEvent(self.__OnClickShowGoldOnButton)
			self.RefreshGoldLogStatus()

			self.showFramesList[0].SetToggleUpEvent(self.__OnClickFramesOnButton)
			self.showFramesList[0].SetToggleDownEvent(self.__OnClickFramesOffButton)
			self.RefreshFramesStatus()

			self.OfflineShopsList[0].SetToggleUpEvent(self.__OfflineShopDisableHide)
			self.OfflineShopsList[0].SetToggleDownEvent(self.__OfflineShopEnableHide)
			self.RefreshOfflineShops()


		self.__ClickRadioButton(self.nameColorModeButtonList, constInfo.GET_CHRNAME_COLOR_INDEX())
		self.__ClickRadioButton(self.viewTargetBoardButtonList, constInfo.GET_VIEW_OTHER_EMPIRE_PLAYER_TARGET_BOARD())
		self.__SetPeacePKMode()

	def __ClickRadioButton(self, buttonList, buttonIndex):
		try:
			selButton=buttonList[buttonIndex]
		except IndexError:
			return

		for eachButton in buttonList:
			eachButton.SetUp()

		selButton.Down()

	def __SetNameColorMode(self, index):
		constInfo.SET_CHRNAME_COLOR_INDEX(index)
		self.__ClickRadioButton(self.nameColorModeButtonList, index)

	def __SetTargetBoardViewMode(self, flag):
		constInfo.SET_VIEW_OTHER_EMPIRE_PLAYER_TARGET_BOARD(flag)
		self.__ClickRadioButton(self.viewTargetBoardButtonList, flag)

	def __OnClickNameColorModeNormalButton(self):
		self.__SetNameColorMode(0)

	def __OnClickNameColorModeEmpireButton(self):
		self.__SetNameColorMode(1)

	def __OnClickTargetBoardViewButton(self):
		self.__SetTargetBoardViewMode(0)

	def __OnClickTargetBoardNoViewButton(self):
		self.__SetTargetBoardViewMode(1)

	def __OnClickBlockExchangeButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_EXCHANGE))
	def __OnClickBlockPartyButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_PARTY))
	def __OnClickBlockGuildButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_GUILD))
	def __OnClickBlockWhisperButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_WHISPER))
	def __OnClickBlockFriendButton(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_FRIEND))
	def __OnClickBlockPartyRequest(self):
		self.RefreshBlock()
		global blockMode
		net.SendChatPacket("/setblockmode " + str(blockMode ^ player.BLOCK_PARTY_REQUEST))

	def __OnClickViewChatOnButton(self):
		global viewChatMode
		viewChatMode = 1
		systemSetting.SetViewChatFlag(viewChatMode)
		self.RefreshViewChat()

	def __OnClickViewChatOffButton(self):
		global viewChatMode
		viewChatMode = 0
		systemSetting.SetViewChatFlag(viewChatMode)
		self.RefreshViewChat()

	def __OnClickAlwaysShowNameOnButton(self):
		systemSetting.SetAlwaysShowNameFlag(True)
		self.RefreshAlwaysShowName()

	def __OnClickAlwaysShowNameOffButton(self):
		systemSetting.SetAlwaysShowNameFlag(False)
		self.RefreshAlwaysShowName()

	def __OnClickShowDamageOnButton(self):
		systemSetting.SetShowDamageFlag(True)
		self.RefreshShowDamage()

	def __OnClickShowDamageOffButton(self):
		systemSetting.SetShowDamageFlag(False)
		self.RefreshShowDamage()

	def __OnClickSalesTextOnButton(self):
		systemSetting.SetShowSalesTextFlag(True)
		self.RefreshShowSalesText()
		uiPrivateShopBuilder.RefreshShopBoards()

	def __OnClickSalesTextOffButton(self):
		systemSetting.SetShowSalesTextFlag(False)
		self.RefreshShowSalesText()

	if app.ENABLE_NEW_GAME_OPTIONS:
		def __OnClickShowGoldOnButton(self):
			systemSetting.SetShowMoneyLog(False)
			systemSetting.SaveConfig()

		def __OnClickShowGoldOffButton(self):
			systemSetting.SetShowMoneyLog(True)
			systemSetting.SaveConfig()

		def RefreshGoldLogStatus(self):
			if systemSetting.IsShowMoneyLog():
				self.showGoldLogButtonList[0].Down()
			else:
				self.showGoldLogButtonList[0].SetUp()

		def __ChatFilterDiceEnable(self) :
			chatID = chat.CreateChatSet(chat.CHAT_SET_CHAT_WINDOW)
			systemSetting.SetEnableChatFilterDice(1)
			chat.EnableChatMode(chatID, chat.CHAT_TYPE_DICE_INFO, 1)

		def __ChatFilterDiceDisable(self) :
			chatID = chat.CreateChatSet(chat.CHAT_SET_CHAT_WINDOW)
			systemSetting.SetEnableChatFilterDice(0)
			chat.DisableChatMode(chatID, chat.CHAT_TYPE_DICE_INFO, 0)

		def __ChatFilterRefresh(self) :
			if systemSetting.IsEnableChatFilterDice():
				self.chatFilterList[0].SetUp()
				self.__ChatFilterDiceEnable()
			else:
				self.chatFilterList[0].Down()
				self.__ChatFilterDiceDisable()


		def __OfflineShopEnableHide(self):
			systemSetting.SetShowOfflineShop(1)
			systemSetting.SaveConfig()

			if app.__ENABLE_NEW_OFFLINESHOP__:
				offlineshop.HideShopEntities()

		def __OfflineShopDisableHide(self):
			systemSetting.SetShowOfflineShop(0)
			systemSetting.SaveConfig()

			if app.__ENABLE_NEW_OFFLINESHOP__:
				offlineshop.ShowShopEntities()

		def RefreshOfflineShops(self):
			if systemSetting.IsShowOfflineShop() == 1:
				self.OfflineShopsList[0].Down()
			else:
				self.OfflineShopsList[0].SetUp()

		def __OnClickFramesOffButton(self):
			systemSetting.SetShowFrames(False)
			systemSetting.SaveConfig()

		def __OnClickFramesOnButton(self):
			systemSetting.SetShowFrames(True)
			systemSetting.SaveConfig()

		def RefreshFramesStatus(self):
			if systemSetting.IsShowFrames():
				self.showFramesList[0].SetUp()
			else:
				self.showFramesList[0].Down()


	def __OnClickHidePetsButton(self):
		systemSetting.SetHidePets(not systemSetting.IsHidePets())
		self.RefreshShowCompanions()

	def __OnClickHideMountsButton(self):
		systemSetting.SetHideMounts(not systemSetting.IsHideMounts())
		self.RefreshShowCompanions()


	def __CheckPvPProtectedLevelPlayer(self):
		if player.GetStatus(player.LEVEL)<constInfo.PVPMODE_PROTECTED_LEVEL:
			self.__SetPeacePKMode()
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_PROTECT % (constInfo.PVPMODE_PROTECTED_LEVEL))
			return 1

		return 0

	def __SetPKMode(self, mode):
		for btn in self.pvpModeButtonDict.values():
			btn.SetUp()
		if self.pvpModeButtonDict.has_key(mode):
			self.pvpModeButtonDict[mode].Down()

	def __SetPeacePKMode(self):
		self.__SetPKMode(player.PK_MODE_PEACE)

	def __RefreshPVPButtonList(self):
		self.__SetPKMode(player.GetPKMode())

	def __OnClickPvPModePeaceButton(self):
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 0", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeRevengeButton(self):
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 1", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeFreeButton(self):
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 2", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def __OnClickPvPModeGuildButton(self):
		if self.__CheckPvPProtectedLevelPlayer():
			return

		self.__RefreshPVPButtonList()

		if 0 == player.GetGuildID():
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_CANNOT_SET_GUILD_MODE)
			return

		if constInfo.PVPMODE_ENABLE:
			net.SendChatPacket("/pkmode 4", chat.CHAT_TYPE_TALKING)
		else:
			chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OPTION_PVPMODE_NOT_SUPPORT)

	def OnChangePKMode(self):
		self.__RefreshPVPButtonList()

	def OnCloseInputDialog(self):
		self.inputDialog.Close()
		self.inputDialog = None
		return True

	def OnCloseQuestionDialog(self):
		self.questionDialog.Close()
		self.questionDialog = None
		return True

	def OnPressEscapeKey(self):
		self.Close()
		return True

	def RefreshBlock(self):
		global blockMode
		for i in xrange(len(self.blockButtonList)):
			if 0 != (blockMode & (1 << i)):
				self.blockButtonList[i].Down()
			else:
				self.blockButtonList[i].SetUp()

	def RefreshViewChat(self):
		if systemSetting.IsViewChat():
			self.viewChatButtonList[0].Down()
			self.viewChatButtonList[1].SetUp()
		else:
			self.viewChatButtonList[0].SetUp()
			self.viewChatButtonList[1].Down()

	def RefreshAlwaysShowName(self):
		if systemSetting.IsAlwaysShowName():
			self.alwaysShowNameButtonList[0].Down()
			self.alwaysShowNameButtonList[1].SetUp()
		else:
			self.alwaysShowNameButtonList[0].SetUp()
			self.alwaysShowNameButtonList[1].Down()

	def RefreshShowDamage(self):
		if systemSetting.IsShowDamage():
			self.showDamageButtonList[0].Down()
			self.showDamageButtonList[1].SetUp()
		else:
			self.showDamageButtonList[0].SetUp()
			self.showDamageButtonList[1].Down()

	def RefreshShowSalesText(self):
		if systemSetting.IsShowSalesText():
			self.showsalesTextButtonList[0].Down()
			self.showsalesTextButtonList[1].SetUp()
		else:
			self.showsalesTextButtonList[0].SetUp()
			self.showsalesTextButtonList[1].Down()

	def RefreshShowCompanions(self):
		if systemSetting.IsHidePets():
			self.showCompanionsButtonList[0].Down()
		else:
			self.showCompanionsButtonList[0].SetUp()

		if systemSetting.IsHideMounts():
			self.showCompanionsButtonList[1].Down()
		else:
			self.showCompanionsButtonList[1].SetUp()

	if app.ENABLE_PICKUP_FILTER:
		def __OnClickPickupIgnoreButton(self, type, ignore):
			systemSetting.SetPickupIgnore(type, ignore)
			self.__RefreshPickupIgnoreButtons()

		def __RefreshPickupIgnoreButtons(self):
			for i in xrange(len(self.pickupIgnoreButtonList)):
				if systemSetting.GetPickupIgnore(i):
					self.pickupIgnoreButtonList[i].Down()
				else:
					self.pickupIgnoreButtonList[i].SetUp()

	def OnBlockMode(self, mode):
		global blockMode
		blockMode = mode
		self.RefreshBlock()

	def Show(self):
		self.RefreshBlock()
		ui.ScriptWindow.Show(self)

	def Close(self):
		self.Hide()
